﻿using Harmony;
using RimWorld;
using RimWorld.BaseGen;
using System;
using System.Linq;
using System.Reflection;
using Verse;

namespace RFR_Code {
	
	[StaticConstructorOnStartup]
	internal static class REB_Initializer {
		static REB_Initializer() {
			HarmonyInstance harmony = HarmonyInstance.Create("net.rainbeau.rimworld.mod.fewerruins");
			harmony.Patch(AccessTools.Method(typeof(GenStep_ScatterRuinsSimple), "ScatterAt"), new HarmonyMethod(typeof(RFR_GenStep_ScatterRuinsSimple), "ScatterAtPrefix"), null);
		}
	}

	public static class RFR_GenStep_ScatterRuinsSimple {
		public static bool ScatterAtPrefix(IntVec3 c, Map map) {
			ThingDef thingDef = BaseGenUtility.RandomCheapWallStuff(null, true);
			if (Rand.Value < 0.9f) {
				int sizeX = Rand.Range(5, 11);
				int sizeZ = Rand.Range(5, 11);
				CellRect cellRect = new CellRect(c.x, c.z, sizeX, sizeZ);
				CellRect cellRect1 = cellRect.ClipInsideMap(map);
				MethodInfo locationCheck = typeof(GenStep_ScatterRuinsSimple).GetMethod("CanPlaceAncientBuildingInRange", BindingFlags.NonPublic | BindingFlags.Instance);
				bool b = (bool) locationCheck.Invoke(new GenStep_ScatterRuinsSimple(), new Object[] {cellRect1, map});
				if (b.Equals(true)) {
					BaseGen.globalSettings.map = map;
					BaseGen.symbolStack.Push("ancientRuins", cellRect1);
					BaseGen.Generate();
				}
			}
			else {
				bool flag = Rand.Bool;
				int randomInRange = Rand.Range(3, 11);
                CellRect cellRect2 = new CellRect(c.x, c.z, (!flag ? 1 : randomInRange), (!flag ? randomInRange : 1));
				MethodInfo locationCheck = typeof(GenStep_ScatterRuinsSimple).GetMethod("CanPlaceAncientBuildingInRange", BindingFlags.NonPublic | BindingFlags.Instance);
				bool b = (bool) locationCheck.Invoke(new GenStep_ScatterRuinsSimple(), new Object[] {cellRect2.ExpandedBy(1), map});
				if (b.Equals(true)) {
					typeof(GenStep_ScatterRuinsSimple).GetMethod("MakeLongWall", BindingFlags.NonPublic | BindingFlags.Instance).Invoke(new GenStep_ScatterRuinsSimple(), new Object[] {c, map, randomInRange, flag, thingDef});
				}
			}
			return false;
		}
	}
        
}
